
import gurobipy as gp

# Create a new model
model = gp.Model("BakeryOptimization")

# Create variables
donuts = model.addVar(vtype=gp.GRB.CONTINUOUS, name="donuts")  # x1
cookies = model.addVar(vtype=gp.GRB.CONTINUOUS, name="cookies") # x2

# Set objective function
model.setObjective(20 * donuts + 15 * cookies, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * donuts + 5 * cookies <= 200, "Jake's Time")
model.addConstr(10 * donuts + 25 * cookies <= 300, "Jill's Time")
model.addConstr(donuts >= 0, "Donuts Non-Negative")
model.addConstr(cookies >= 0, "Cookies Non-Negative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Donuts: {donuts.x}")
    print(f"  Cookies: {cookies.x}")
    print(f"  Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

