
from gurobipy import *

# Create a model
m = Model("Bakery_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="donuts")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="cookies")

# Set objective function
m.setObjective(20*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 5*x2 <= 200, "jake_time")
m.addConstr(10*x1 + 25*x2 <= 300, "jill_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Donuts: {x1.x}")
    print(f"Cookies: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
