
import gurobipy as gp

# Create a new model
model = gp.Model("Donuts_and_Cookies")

# Define variables
x1 = model.addVar(name="donuts", lb=0, vtype=gp.GRB.INTEGER)  # batches of donuts
x2 = model.addVar(name="cookies", lb=0, vtype=gp.GRB.INTEGER)  # batches of cookies

# Objective function: maximize profit
model.setObjective(20*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Jake's time constraint
model.addConstr(20*x1 + 5*x2 <= 200, name="Jake_time")

# Jill's time constraint
model.addConstr(10*x1 + 25*x2 <= 300, name="Jill_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal batches of donuts: {x1.varValue}")
    print(f"Optimal batches of cookies: {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
