
import gurobipy as gp

# Create a new model
m = gp.Model("Coffee Blend Optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Drummondville")  # Bags of Drummondville blend
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="Victoriaville") # Bags of Victoriaville blend

# Set objective function
m.setObjective(5*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(600*x1 + 375*x2 <= 24000, "Arabica Constraint")
m.addConstr(400*x1 + 625*x2 <= 17000, "Robusta Constraint")
m.addConstr(x1 >= 0, "Drummondville Non-Negativity")
m.addConstr(x2 >= 0, "Victoriaville Non-Negativity")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Drummondville bags: {x1.x}")
    print(f"Number of Victoriaville bags: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

