
from gurobipy import *

# Create a new model
m = Model("CoffeeBlendOptimization")

# Add variables to the model
x1 = m.addVar(name="Drummondville", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Victoriaville", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(600*x1 + 375*x2 <= 24000, name="ArabicaConstraint")
m.addConstr(400*x1 + 625*x2 <= 17000, name="RobustaConstraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Drummondville: {x1.x}")
    print(f"Victoriaville: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
