
import gurobipy as gp

# Create a new model
model = gp.Model("CoffeeBlends")

# Define the variables
x1 = model.addVar(name="Drummondville_blend_bags", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="Victoriaville_blend_bags", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(5*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(600*x1 + 375*x2 <= 24000, name="Arabica_beans_constraint")
model.addConstr(400*x1 + 625*x2 <= 17000, name="Robusta_beans_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Drummondville blend bags: {x1.varValue}")
    print(f"Number of Victoriaville blend bags: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("No optimal solution found.")
