
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
beans = m.addVar(lb=0, name="beans")  # Acres of beans
peas = m.addVar(lb=0, name="peas")  # Acres of peas


# Set objective function: Maximize profit
m.setObjective(200 * beans + 250 * peas, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(beans + peas <= 100, "land_constraint")  # Total land constraint
m.addConstr(12 * beans + 15 * peas <= 1350, "repellant_constraint")  # Bug repellant constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Acres of beans: {beans.x}")
    print(f"  Acres of peas: {peas.x}")
    print(f"  Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

