
from gurobipy import *

# Create a new model
m = Model("Gardener_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="acres_of_beans")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="acres_of_peas")

# Set the objective function
m.setObjective(200*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_land_constraint")
m.addConstr(12*x1 + 15*x2 <= 1350, "bug_repellant_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of beans: {x1.x}")
    print(f"Acres of peas: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 250*x2.x:.2f}")
else:
    print("No optimal solution found.")
