
import gurobipy as gp

# Create a new model
model = gp.Model("Gardener_Problem")

# Define the variables
x1 = model.addVar(name="beans", lb=0, ub=100, vtype=gp.GRB.CONTINUOUS)  # acres of beans
x2 = model.addVar(name="peas", lb=0, ub=100, vtype=gp.GRB.CONTINUOUS)  # acres of peas

# Define the objective function
model.setObjective(200*x1 + 250*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 100, name="total_acres")
model.addConstr(12*x1 + 15*x2 <= 1350, name="bug_repellant")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of beans: {x1.varValue}")
    print(f"Optimal acres of peas: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("The model is infeasible.")
