
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
textile_investment = m.addVar(name="textile_investment")
telecom_investment = m.addVar(name="telecom_investment")

# Set objective function
m.setObjective(0.06 * textile_investment + 0.08 * telecom_investment, GRB.MAXIMIZE)

# Add constraints
m.addConstr(textile_investment + telecom_investment <= 500000, "total_investment")
m.addConstr(textile_investment >= 0.3 * (textile_investment + telecom_investment), "min_textile")
m.addConstr(telecom_investment <= 0.5 * (textile_investment + telecom_investment), "max_telecom")
m.addConstr(textile_investment >= 0, "non_negative_textile")  # Ensure non-negativity
m.addConstr(telecom_investment >= 0, "non_negative_telecom") # Ensure non-negativity

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal textile investment: {textile_investment.x}")
    print(f"Optimal telecom investment: {telecom_investment.x}")
    print(f"Optimal return: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

