
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="textile_investment")
x2 = m.addVar(lb=0, name="telecom_investment")

# Set the objective function
m.setObjective(0.06*x1 + 0.08*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 500000, "total_investment")
m.addConstr(x1 >= 150000, "min_textile_investment")
m.addConstr(x2 <= 250000, "max_telecom_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Textile Investment: $", x1.x)
    print("Telecom Investment: $", x2.x)
else:
    print("No optimal solution found.")
