
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="textile_investment", lb=0)
    x2 = model.addVar(name="telecom_investment", lb=0)

    # Objective function: maximize 0.06x1 + 0.08x2
    model.setObjective(0.06 * x1 + 0.08 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500000)
    model.addConstr(x1 >= 0.3 * 500000)
    model.addConstr(x2 <= 0.5 * 500000)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in textile industry: ", x1.varValue)
        print("Optimal investment in telecom industry: ", x2.varValue)
        print("Maximum return: ", model.objVal)
    else:
        print("The model is infeasible")

solve_investment_problem()
