
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Peanut_Transportation")

# Create variables
train_trips = m.addVar(vtype=GRB.INTEGER, name="train_trips")
truck_trips = m.addVar(vtype=GRB.INTEGER, name="truck_trips")

# Set objective function
m.setObjective(80 * train_trips + 50 * truck_trips, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50 * train_trips + 40 * truck_trips <= 3000, "budget_constraint")
m.addConstr(train_trips <= truck_trips, "trips_constraint")
m.addConstr(train_trips >=0, "non_negativity_train")
m.addConstr(truck_trips >=0, "non_negativity_truck")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of train trips: {train_trips.x}")
    print(f"Optimal number of truck trips: {truck_trips.x}")
    print(f"Maximum number of packages transported: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

