
from gurobipy import *

# Create a new model
m = Model("Peanut_Transportation")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="train_trips")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="truck_trips")

# Set the objective function
m.setObjective(80*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x1 + 40*x2 <= 3000, "cost_constraint")
m.addConstr(x1 <= x2, "trip_constraint")
m.addConstr(x1 >= 0, "non_neg_train_trips")
m.addConstr(x2 >= 0, "non_neg_truck_trips")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of train trips: {x1.x}")
    print(f"Number of truck trips: {x2.x}")
    print(f"Total packages transported: {80*x1.x + 50*x2.x}")
else:
    print("No optimal solution found")
