
import gurobipy as gp

def solve_transportation_problem():
    # Create a new model
    model = gp.Model("PeanutTransportation")

    # Define variables
    x1 = model.addVar(name="train_trips", vtype=gp.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="truck_trips", vtype=gp.GRB.INTEGER, lb=0)

    # Objective function: Maximize the total number of packages transported
    model.setObjective(80*x1 + 50*x2, gp.GRB.MAXIMIZE)

    # Cost constraint
    model.addConstr(50*x1 + 40*x2 <= 3000, name="cost_constraint")

    # Trip constraint
    model.addConstr(x1 <= x2, name="trip_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Train Trips: {x1.varValue}")
        print(f"Truck Trips: {x2.varValue}")
        print(f"Total Packages: {80*x1.varValue + 50*x2.varValue}")
    else:
        print("The model is infeasible.")

solve_transportation_problem()
