
import gurobipy as gp

# Create a new model
m = gp.Model("soda_optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="soda1") # Cans of Soda 1
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="soda2") # Cans of Soda 2


# Set objective function
m.setObjective(5*x1 + 7*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 >= 50, "caffeine_constraint")
m.addConstr(2*x1 + 5*x2 >= 40, "sugar_constraint")
m.addConstr(x1 >= 0, "soda1_nonnegative")
m.addConstr(x2 >= 0, "soda2_nonnegative")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal cost: ${m.objVal}")
    print(f"Number of Soda 1 cans: {x1.x}")
    print(f"Number of Soda 2 cans: {x2.x}")

