
from gurobipy import *

# Create a new model
m = Model("Soda_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 >= 50, name="caffeine_constraint")
m.addConstr(2*x1 + 5*x2 >= 40, name="sugar_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x1.x} cans of Soda 1")
    print(f"Buy {x2.x} cans of Soda 2")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
