
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Soda1", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Soda2", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(5 * x1 + 7 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 2 * x2 >= 50, name="Caffeine_Constraint")
    model.addConstr(2 * x1 + 5 * x2 >= 40, name="Sugar_Constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Buy {x1.varValue} cans of Soda 1 and {x2.varValue} cans of Soda 2.")
        print(f"Total cost: ${5 * x1.varValue + 7 * x2.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
