
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("fishing_optimization")

# Create variables
pacific_days = m.addVar(lb=0, name="pacific_days")
atlantic_days = m.addVar(lb=0, name="atlantic_days")

# Set objective function
m.setObjective(5000 * pacific_days + 7000 * atlantic_days, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * pacific_days + 4 * atlantic_days >= 18, "fish_constraint")
m.addConstr(2 * pacific_days + 3 * atlantic_days >= 10, "crab_constraint")
m.addConstr(0.5 * pacific_days + atlantic_days >= 5, "lobster_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Days fishing in the Pacific: {pacific_days.x}")
    print(f"Days fishing in the Atlantic: {atlantic_days.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

