
from gurobipy import *

# Create a new model
model = Model("Fishing_Optimization")

# Define variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Pacific_Days")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Atlantic_Days")

# Set objective function
model.setObjective(5000*x1 + 7000*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(5*x1 + 4*x2 >= 18, "Fish_Catch")
model.addConstr(2*x1 + 3*x2 >= 10, "Crab_Catch")
model.addConstr(0.5*x1 + x2 >= 5, "Lobster_Catch")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pacific Days: {x1.x}")
    print(f"Atlantic Days: {x2.x}")
    print(f"Total Cost: {model.objVal}")
else:
    print("No optimal solution found")
