
import gurobipy as gp

# Create a new model
model = gp.Model("Fishing_Problem")

# Define the variables
x1 = model.addVar(name="Pacific_Days", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="Atlantic_Days", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(5000*x1 + 7000*x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(5*x1 + 4*x2 >= 18, name="Fish_Constraint")
model.addConstr(2*x1 + 3*x2 >= 10, name="Crab_Constraint")
model.addConstr(0.5*x1 + x2 >= 5, name="Lobster_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Days in Pacific: {x1.varValue}")
    print(f"Days in Atlantic: {x2.varValue}")
    print(f"Total Cost: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
