
import gurobipy as gp

# Create a new model
m = gp.Model("food_truck")

# Create variables
fries = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="fries")
onion_rings = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="onion_rings")


# Set objective function
m.setObjective(4 * fries + 5 * onion_rings, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(fries >= 20, "min_fries")
m.addConstr(fries <= 50, "max_fries")
m.addConstr(onion_rings >= 10, "min_onion_rings")
m.addConstr(onion_rings <= 40, "max_onion_rings")
m.addConstr(fries + onion_rings <= 50, "total_orders")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Orders of fries: {fries.x}")
    print(f"Orders of onion rings: {onion_rings.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

