
from gurobipy import *

# Create a new model
m = Model("FoodTruckProfit")

# Define the variables
x1 = m.addVar(lb=20, ub=50, vtype=GRB.INTEGER, name="orders_of_fries")
x2 = m.addVar(lb=10, ub=40, vtype=GRB.INTEGER, name="orders_of_onion_rings")

# Define the objective function
m.setObjective(4*x1 + 5*x2, GRB.MAXIMIZE)

# Add the constraint for total orders
m.addConstr(x1 + x2 <= 50, "total_orders_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Orders of Fries: {x1.x}")
    print(f"Orders of Onion Rings: {x2.x}")
    print(f"Total Profit: ${4*x1.x + 5*x2.x}")
else:
    print("No optimal solution found")
