
import gurobi

def solve_food_truck_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x1 = m.addVar(lb=20, ub=50, name="fries")
    x2 = m.addVar(lb=10, ub=40, name="onion_rings")

    # Objective function: Maximize profit
    m.setObjective(4*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(x1 + x2 <= 50, name="total_orders")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Max Profit: {m.objVal}")
    else:
        print("No optimal solution found")

solve_food_truck_problem()
