
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize Viewership")

# Create variables
grocery_ads = model.addVar(vtype=gp.GRB.INTEGER, name="grocery_ads")
train_ads = model.addVar(vtype=gp.GRB.INTEGER, name="train_ads")
water_ads = model.addVar(vtype=gp.GRB.INTEGER, name="water_ads")

# Set objective function
model.setObjective(10000 * grocery_ads + 20000 * train_ads + 50000 * water_ads, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(300 * grocery_ads + 500 * train_ads + 1000 * water_ads <= 50000, "budget_constraint")
model.addConstr(train_ads <= 15, "train_limit")
model.addConstr(water_ads <= (grocery_ads + train_ads + water_ads) / 3, "water_park_balance")
model.addConstr(grocery_ads >= 0.1 * (grocery_ads + train_ads + water_ads), "grocery_store_minimum")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Viewership: {model.objVal}")
    print(f"Number of Grocery Store Ads: {grocery_ads.x}")
    print(f"Number of Train Station Ads: {train_ads.x}")
    print(f"Number of Water Park Ads: {water_ads.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

