
import gurobi

def solve_ads_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # ads in grocery stores
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # ads at train stations
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # ads in water parks

    # Objective function: Maximize viewership
    model.setObjective(10000*x1 + 20000*x2 + 50000*x3, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(300*x1 + 500*x2 + 1000*x3 <= 50000)

    # Train station ad limit
    model.addConstr(x2 <= 15)

    # Water park ad limit
    model.addConstr(x3 <= (1/3)*(x1 + x2 + x3))

    # Grocery store ad minimum
    model.addConstr(x1 >= 0.1*(x1 + x2 + x3))

    # Non-negativity constraints (implied by integer type)

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ads in grocery stores: {x1.varValue}")
        print(f"Ads at train stations: {x2.varValue}")
        print(f"Ads in water parks: {x3.varValue}")
        print(f"Max viewership: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_ads_problem()
