
from gurobipy import Model, GRB

# Create a new model
m = Model("Art Gallery Optimization")

# Create variables
paintings = m.addVar(vtype=GRB.INTEGER, name="paintings")
photo_prints = m.addVar(vtype=GRB.INTEGER, name="photo_prints")

# Set objective function
m.setObjective(330 * paintings + 170 * photo_prints, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * paintings + 4 * photo_prints <= 200, "Wall space")
m.addConstr(400 * paintings + 200 * photo_prints <= 7000, "Budget")
m.addConstr(photo_prints >= 0.2 * (paintings + photo_prints), "Photo print proportion")
m.addConstr(paintings >= 0, "Non-negative paintings")
m.addConstr(photo_prints >= 0, "Non-negative photo prints")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of paintings: {paintings.x}")
    print(f"Number of photo prints: {photo_prints.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

