
from gurobipy import *

# Create a new model
m = Model("Art Gallery Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="number_of_paintings")
x2 = m.addVar(vtype=GRB.INTEGER, name="number_of_photo_prints")

# Set the objective function
m.setObjective(330*x1 + 170*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 4*x2 <= 200, "wall_space_constraint")
m.addConstr(400*x1 + 200*x2 <= 7000, "budget_constraint")
m.addConstr(4*x2 >= x1, "photo_prints_percentage_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal} profit")
    print(f"Number of paintings: {x1.x}")
    print(f"Number of photo prints: {x2.x}")
else:
    print("No optimal solution found")
