
import gurobi

def solve_gallery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='paintings', vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name='photo_prints', vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function
    model.setObjective(330*x1 + 170*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7*x1 + 4*x2 <= 200, name='wall_space')
    model.addConstr(400*x1 + 200*x2 <= 7000, name='budget')
    model.addConstr(x2 >= 0.2*(x1 + x2), name='photo_prints_percentage')

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    else:
        print("No optimal solution found")

solve_gallery_problem()
