
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
pop_investment = m.addVar(name="pop_investment")
rapper_investment = m.addVar(name="rapper_investment")

# Set objective function
m.setObjective(0.03 * pop_investment + 0.05 * rapper_investment, GRB.MAXIMIZE)

# Add constraints
m.addConstr(pop_investment + rapper_investment <= 400000, "total_investment")
m.addConstr(pop_investment >= 3 * rapper_investment, "pop_rapper_ratio")
m.addConstr(pop_investment <= 250000, "pop_investment_limit")
m.addConstr(pop_investment >= 0, "pop_non_negative")  # Ensure non-negative investments
m.addConstr(rapper_investment >= 0, "rapper_non_negative") # Ensure non-negative investments


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in pop artist: {pop_investment.x}")
    print(f"Optimal investment in rapper: {rapper_investment.x}")
    print(f"Maximum earnings: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

