
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(name="Rapper_Investment", lb=0)  # Amount invested in the rapper
x2 = m.addVar(name="Pop_Artist_Investment", lb=0)  # Amount invested in the pop artist

# Set objective function: Maximize earnings
m.setObjective(0.05*x1 + 0.03*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 400000, name="Total_Investment")  # Total investment constraint
m.addConstr(x2 >= 3*x1, name="Investment_Ratio")  # Minimum ratio of pop to rapper investment
m.addConstr(x2 <= 250000, name="Max_Pop_Investment")  # Maximum investment in the pop artist

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in the rapper: ${x1.X:.2f}")
    print(f"Amount invested in the pop artist: ${x2.X:.2f}")
    print(f"Total earnings: ${m.ObjVal:.2f}")
else:
    print("No optimal solution found.")
