
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Problem")

# Define the variables
x1 = model.addVar(name="rapper_investment", lb=0)  # Amount invested in the rapper
x2 = model.addVar(name="pop_artist_investment", lb=0)  # Amount invested in the pop artist

# Objective function: maximize earnings
model.setObjective(0.05 * x1 + 0.03 * x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 400000, name="total_investment")
model.addConstr(x2 <= 250000, name="pop_artist_limit")
model.addConstr(x2 >= 3 * x1, name="pop_artist_to_rapper_ratio")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in rapper: ${x1.varValue:.2f}")
    print(f"Optimal investment in pop artist: ${x2.varValue:.2f}")
    print(f"Max earnings: ${0.05 * x1.varValue + 0.03 * x2.varValue:.2f}")
else:
    print("The model is infeasible.")
