
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
lettuce = m.addVar(lb=0, name="lettuce")
spinach = m.addVar(lb=0, name="spinach")

# Set objective function
m.setObjective(50 * lettuce + 55 * spinach, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(lettuce + spinach <= 50, "land_constraint")
m.addConstr(10 * lettuce + 12 * spinach <= 5000, "watering_constraint")
m.addConstr(2 * lettuce + spinach <= 300, "picking_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Lettuce: {lettuce.x} acres")
    print(f"Spinach: {spinach.x} acres")
    print(f"Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

