
import gurobipy as gp

# Create a new model
m = gp.Model("museum_gift_shop")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # Package 1
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # Package 2


# Set objective function
m.setObjective(10*x1 + 12*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 <= 1000, "souvenir_constraint")
m.addConstr(10*x1 + 15*x2 <= 1400, "snack_constraint")
m.addConstr(x1 >= 0, "x1_nonnegativity")
m.addConstr(x2 >= 0, "x2_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of Package 1 to sell: {x1.x:.2f}")
    print(f"Number of Package 2 to sell: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

