
from gurobipy import *

# Create a new model
m = Model("Museum_Gift_Shop")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Package1")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Package2")

# Set the objective function
m.setObjective(10*x1 + 12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 4*x2 <= 1000, "SouvenirConstraint")
m.addConstr(10*x1 + 15*x2 <= 1400, "SnackConstraint")
m.addConstr(x1 >= 0, "NonNegativity_x1")
m.addConstr(x2 >= 0, "NonNegativity_x2")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Packages of Type 1 to sell:", x1.x)
    print("Packages of Type 2 to sell:", x2.x)
    print("Maximum Profit: $", m.objVal)
else:
    print("No optimal solution found")
