
import gurobi

def solve_museum_gift_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="Package_1", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="Package_2", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 10*x1 + 12*x2
    model.setObjective(10*x1 + 12*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 4*x2 <= 1000, name="souvenir_constraint")
    model.addConstr(10*x1 + 15*x2 <= 1400, name="snack_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of Package 1 to sell: {x1.varValue}")
        print(f"Number of Package 2 to sell: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_museum_gift_shop_problem()
