
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximus_Advertising")

# Create variables
billboard_ads = model.addVar(vtype=GRB.INTEGER, name="billboard_ads")
podcast_ads = model.addVar(vtype=GRB.INTEGER, name="podcast_ads")
merchandise_ads = model.addVar(vtype=GRB.INTEGER, name="merchandise_ads")

# Set objective function
model.setObjective(40000 * billboard_ads + 10000 * podcast_ads + 2000 * merchandise_ads, GRB.MAXIMIZE)

# Add constraints
model.addConstr(750 * billboard_ads + 1000 * podcast_ads + 300 * merchandise_ads <= 20000, "budget_constraint")
model.addConstr(billboard_ads <= 3, "billboard_limit")
model.addConstr(merchandise_ads <= 0.4 * (billboard_ads + podcast_ads + merchandise_ads), "merchandise_proportion")
model.addConstr(podcast_ads >= 0.25 * (billboard_ads + podcast_ads + merchandise_ads), "podcast_proportion")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Viewership: {model.objVal}")
    print(f"Number of Billboard Ads: {billboard_ads.x}")
    print(f"Number of Podcast Ads: {podcast_ads.x}")
    print(f"Number of Merchandise Ads: {merchandise_ads.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

