
import gurobi

def solve_maximus_ads():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="billboards", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="podcasts", vtype=gurobi.GRB.INTEGER, lb=0)
    x3 = model.addVar(name="merchandises", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function
    model.setObjective(40000*x1 + 10000*x2 + 2000*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(750*x1 + 1000*x2 + 300*x3 <= 20000, name="budget_constraint")
    model.addConstr(x1 <= 3, name="billboard_limit")
    model.addConstr(1.5*x3 <= x1 + x2, name="merchandise_limit")
    model.addConstr(3*x2 >= x1 + x3, name="podcast_requirement")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Ads on billboards: {x1.varValue}")
        print(f"Ads on podcasts: {x2.varValue}")
        print(f"Ads on merchandises: {x3.varValue}")
        print(f"Max viewership: {40000*x1.varValue + 10000*x2.varValue + 2000*x3.varValue}")
    else:
        print("No optimal solution found.")

solve_maximus_ads()
