
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture Production")

# Create decision variables
bedside_tables = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bedside_tables")
bookcases = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bookcases")


# Set objective function
model.setObjective(200 * bedside_tables + 500 * bookcases, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2.5 * bedside_tables + 5 * bookcases <= 30, "Crafting Constraint")
model.addConstr(1.5 * bedside_tables + 3 * bookcases <= 20, "Polishing Constraint")
model.addConstr(bedside_tables >=0)
model.addConstr(bookcases >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Objective Value: {model.objVal}")
    print(f"Number of Bedside Tables: {bedside_tables.x}")
    print(f"Number of Bookcases: {bookcases.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

