
from gurobipy import *

# Create a new model
model = Model("Furniture_Factory")

# Define variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="bedside_tables", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="bookcases", lb=0)

# Set objective function
model.setObjective(200*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2.5*x1 + 5*x2 <= 30, "crafting_hours")
model.addConstr(1.5*x1 + 3*x2 <= 20, "polishing_hours")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bedside tables: {x1.x}")
    print(f"Bookcases: {x2.x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
