
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture_Factory_Optimization")

# Define the variables
x1 = model.addVar(name="bedside_tables", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="bookcases", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(200*x1 + 500*x2, gp.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(2.5*x1 + 5*x2 <= 30, name="crafting_hours")
model.addConstr(1.5*x1 + 3*x2 <= 20, name="polishing_hours")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${200*x1.varValue + 500*x2.varValue:.2f}")
else:
    print("No optimal solution found.")
