
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bagel_mix")

# Create variables
ordinary_bags = m.addVar(vtype=GRB.CONTINUOUS, name="ordinary_bags")  # x1
special_bags = m.addVar(vtype=GRB.CONTINUOUS, name="special_bags")  # x2


# Set objective function
m.setObjective(10 * ordinary_bags + 12 * special_bags, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * ordinary_bags + 10 * special_bags >= 50, "sesame_seeds")
m.addConstr(8 * ordinary_bags + 6 * special_bags >= 60, "onion_powder")
m.addConstr(7 * ordinary_bags + 8 * special_bags >= 65, "garlic_powder")
m.addConstr(ordinary_bags >= 0)
m.addConstr(special_bags >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Number of ordinary bags: {ordinary_bags.x}")
    print(f"Number of special bags: {special_bags.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

