
from gurobipy import *

# Create a new model
m = Model("bagel_mix")

# Define variables
x1 = m.addVar(name="ordinary_bags", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="special_bags", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(10*x1 + 12*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 10*x2 >= 50, name="sesame_seeds")
m.addConstr(8*x1 + 6*x2 >= 60, name="onion_powder")
m.addConstr(7*x1 + 8*x2 >= 65, name="garlic_powder")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ordinary bags: {x1.x}")
    print(f"Special bags: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
