
import gurobi

def solve_bagel_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="ordinary_bags", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="special_bags", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(10*x1 + 12*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(5*x1 + 10*x2 >= 50, name="sesame_seeds")
    model.addConstr(8*x1 + 6*x2 >= 60, name="onion_powder")
    model.addConstr(7*x1 + 8*x2 >= 65, name="garlic_powder")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of ordinary bags: {x1.varValue}")
        print(f"Number of special bags: {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bagel_mix_problem()
