
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Weight_Loss_Program")

# Create variables
vietnamese = m.addVar(lb=0, name="Vietnamese")  # Number of Vietnamese plates
korean = m.addVar(lb=0, name="Korean")  # Number of Korean plates


# Set objective function: Minimize total cost
m.setObjective(12.5 * vietnamese + 16.5 * korean, GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * vietnamese + 10 * korean >= 250, "Protein_Requirement")  # Protein constraint
m.addConstr(20 * vietnamese + 14 * korean >= 45, "Carb_Requirement")  # Carb constraint


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Vietnamese plates: {vietnamese.x:.2f}")
    print(f"Korean plates: {korean.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

