
from gurobipy import *

# Create a new model
m = Model("Weight_Loss_Program")

# Create variables
x1 = m.addVar(lb=0, name="Vietnamese_Food")
x2 = m.addVar(lb=0, name="Korean_Food")

# Set the objective function
m.setObjective(12.5*x1 + 16.5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(15*x1 + 10*x2 >= 250, "Protein_Requirement")
m.addConstr(20*x1 + 14*x2 >= 45, "Carb_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Minimum cost: $", round(m.objVal, 2))
    print("Number of plates of Vietnamese food:", round(x1.x))
    print("Number of plates of Korean food:", round(x2.x))
else:
    print("The model is infeasible")
