
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="vietnamese_food", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="korean_food", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(12.5 * x1 + 16.5 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(15 * x1 + 10 * x2 >= 250, name="protein_requirement")
    model.addConstr(20 * x1 + 14 * x2 >= 45, name="carb_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of plates of Vietnamese food: {x1.varValue}")
        print(f"Number of plates of Korean food: {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
