
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ball_production")

# Create variables
soccer_balls = m.addVar(vtype=GRB.CONTINUOUS, name="soccer_balls")
basket_balls = m.addVar(vtype=GRB.CONTINUOUS, name="basket_balls")


# Set objective function
m.setObjective(5 * soccer_balls + 8 * basket_balls, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * soccer_balls + 15 * basket_balls <= 5000, "sewing_time")
m.addConstr(10 * soccer_balls + 12 * basket_balls <= 4500, "qc_time")
m.addConstr(soccer_balls >= 0, "soccer_balls_nonneg")
m.addConstr(basket_balls >= 0, "basket_balls_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of soccer balls to produce: {soccer_balls.x:.2f}")
    print(f"Number of basket balls to produce: {basket_balls.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

