
from gurobipy import *

# Create a new model
m = Model("Soccer_and_Basketball_Production")

# Define the variables
x1 = m.addVar(name="soccer_balls", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="basketballs", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 5000, name="sewing_time")
m.addConstr(10*x1 + 12*x2 <= 4500, name="quality_checking_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x1.x} soccer balls and {x2.x} basketballs.")
else:
    print("No optimal solution found.")
