
import gurobipy as gp

# Create a new model
model = gp.Model("SoccerBall_BasketBall")

# Define the variables
x1 = model.addVar(name="soccer_balls", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="basket_balls", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(5 * x1 + 8 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * x1 + 15 * x2 <= 5000, name="sewing_time")
model.addConstr(10 * x1 + 12 * x2 <= 4500, name="quality_checking_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: soccer balls = {x1.varValue}, basket balls = {x2.varValue}")
    print(f"Maximum profit: ${5 * x1.varValue + 8 * x2.varValue}")
else:
    print("No optimal solution found.")
